﻿using iText.Kernel.Pdf;
using iText.Kernel.Utils;
using NVCC.Models;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;

namespace NVCC.WebUI.Infrastructure
{
    public class CombinePdfService : ICombinePdfService
    {
        public string CombinePdfs(string refDocPdfPath, IEnumerable<UploadedFile> attachedPdfs, IEnumerable<VistAImagingStudy> vistAImagingStudies = null)
        {
            if ((attachedPdfs == null || !attachedPdfs.Any()) && (vistAImagingStudies == null || !vistAImagingStudies.Any()))
            {
                return refDocPdfPath;
            }
            var combinedPdfPath = Path.GetTempFileName();

            //CreateMergedPDF(combinedPdfPath, refDocPdfPath, attachedPdfs.Select(p => p.FullPath));

            var fileNameList = new List<string>();
            if (attachedPdfs != null && attachedPdfs.Any(a => !string.IsNullOrWhiteSpace(a.FullPath)))
            {
                fileNameList.AddRange(attachedPdfs.Select(p => p.FullPath));
            }

            MergePdfFiles(combinedPdfPath, refDocPdfPath, fileNameList, vistAImagingStudies);


            return combinedPdfPath;
        }

        private void MergePdfFiles(string outputPdf, string refDocPath, List<string> sourcePdfs, IEnumerable<VistAImagingStudy> vistAImagingStudies)
        {
            FileStream outputStream = new FileStream(outputPdf, FileMode.Create, FileAccess.Write);

            WriterProperties writerProperties = new WriterProperties();

            //Add metadata
            writerProperties.AddUAXmpMetadata();

            PdfWriter pdfWriter = new PdfWriter(outputStream, writerProperties);

            PdfDocument combinedPdf = new PdfDocument(pdfWriter);

            combinedPdf.SetTagged();
            combinedPdf.GetCatalog().SetLang(new PdfString("en-US"));
            combinedPdf.GetCatalog().SetViewerPreferences(new PdfViewerPreferences().SetDisplayDocTitle(true));
            PdfDocumentInfo info = combinedPdf.GetDocumentInfo();

            //When we set metadata, we assume that this is a RefDoc package (not an ROI Patient or Admin or other PDF)
            //because we are only adding additional attachments to RefDoc packages. If, in the future, this service
            //is used elsewhere, we need to have switch statment with the PdfTypes enumeration or something.
            info.SetTitle("VHA Consult Transmittal with additional attachments.");
            info.SetAuthor("US Department of Veterans Affairs");
            info.AddCreationDate();
            info.GetProducer();
            info.SetCreator("VA Community Care Referral Documentation Tool");
            info.SetKeywords("patient referral, medical history");
            info.SetSubject("Referral for Care");

            PdfMerger merger = new PdfMerger(combinedPdf);

            PdfDocument refDocPdf = new PdfDocument(new PdfReader(refDocPath));
            merger.Merge(refDocPdf, 1, refDocPdf.GetNumberOfPages());
            refDocPdf.Close();

            if (vistAImagingStudies != null && vistAImagingStudies.Any(s => s.Files != null && s.Files.Any(f => f.FileType.Contains("pdf"))))
            {
                foreach (var study in vistAImagingStudies)
                {
                    if (study != null && study.Files != null)
                    {
                        foreach (var file in study.Files)
                        {
                            if (file.FileType.Contains("pdf"))
                            {
                                using (MemoryStream ms = new MemoryStream(file.FileBytes))
                                {
                                    var pdfReader = new PdfReader(ms);
                                    PdfDocument pdfDoc = new PdfDocument(pdfReader);
                                    merger.Merge(pdfDoc, 1, pdfDoc.GetNumberOfPages());
                                    pdfDoc.Close();
                                }
                            }
                        }
                    }
                }
            }
            
            foreach (var path in sourcePdfs)
            {
                PdfDocument pdfDoc = new PdfDocument(new PdfReader(path));
                merger.Merge(pdfDoc, 1, pdfDoc.GetNumberOfPages());
                pdfDoc.Close();
            }
           
            combinedPdf.Close();
        }
    }
}